module keyspotting

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program monitors keyboard input that is sent to a Window which consists 
//  of a CompoundControl which consists of a CustomControl.
//  ********************************************************************************

import StdEnv,StdIO,stringconv

::  NoState
    =   NoState

Start :: *World -> *World
Start world
    #	(windowid, world)= openId world
    #	(controlid,world)= openId world
    =	startIO NoState NoState [initialise windowid controlid] [] world
where
    initialise windowid controlid ps
        # custom        = CustomControl customsize (look "")
                            [   ControlKeyboard (const True) Able
                            					(noLS1 (spotting "Control"))
                            ,   ControlId       controlid
                            ]
        # compound      = CompoundControl custom
                            [   ControlKeyboard (const True) Able
                            					(noLS1 (spotting "Compound"))
                            ,   ControlSize     {w=customsize.w+2*margin
                            					,h=customsize.h+2*margin
                            					}
                            ,   ControlLook     (look "")
                            ]
        # window        = Window "keyspotting" compound
                            [   WindowKeyboard  (const True) Able
                            					(noLS1 (spotting "Window"))
                            ,   WindowId        windowid
                            ,   WindowSize      {w=customsize.w+4*margin
                            					,h=customsize.h+4*margin
                            					}
                            ,   WindowClose     (noLS closeProcess)
                            ,   WindowHMargin   margin margin
                            ,   WindowVMargin   margin margin
                            ]
        # (error,ps)    = openWindow NoState window ps
        | error<>NoError
            =	abort "keyspotting could not open window"
        | otherwise
            =	ps
    where
        customsize  = {w=550,h=100}
        margin      = 10
        spotting who key ps
            =	appPIO (setWindow windowid
                       [setControlLooks [(controlid,True,look text)]]
                       ) ps
        where
        	text	= who+++":"+++toString key
        look text _ {newFrame}
            =	[ setPenColour White, fill newFrame
                , setPenColour Black, draw newFrame
                , drawAt {x=10,y=customsize.h/2} text
                ]
